/****** Object:  Table [dbo].[ClinicalSpecialty] ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [hipsui].[ClinicalSpecialty](
	[ClinicalSpecialtyId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](50) NOT NULL,
	[Description] [varchar](100) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_ClinicalSpecialty] PRIMARY KEY CLUSTERED 
(
	[ClinicalSpecialtyId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

/****** Object:  Table [hipsui].[IdentityVerificationMethod]    ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hipsui].[IdentityVerificationMethod]') AND type in (N'U'))
BEGIN
CREATE TABLE [hipsui].[IdentityVerificationMethod](
	[IdentityVerificationMethodId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](50) NOT NULL,
	[Description] [varchar](250) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[IsEnabled] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_IdentityVerificationMethod] PRIMARY KEY CLUSTERED 
(
	[IdentityVerificationMethodId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[hipsui].[IdentityVerificationMethod]') AND name = N'UK_IdentityVerificationMethod_Code')
CREATE UNIQUE NONCLUSTERED INDEX [UK_IdentityVerificationMethod_Code] ON [hipsui].[IdentityVerificationMethod] 
(
	[Code] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[hipsui].[DF_IdentityVerificationMethod_DisplayOrder]') AND parent_object_id = OBJECT_ID(N'[hipsui].[IdentityVerificationMethod]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_IdentityVerificationMethod_DisplayOrder]') AND type = 'D')
BEGIN
ALTER TABLE [hipsui].[IdentityVerificationMethod] ADD  CONSTRAINT [DF_IdentityVerificationMethod_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
END
End
GO

/****** Object:  Table [hipsui].[IndigenousStatus]    ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hipsui].[IndigenousStatus]') AND type in (N'U'))
BEGIN
CREATE TABLE [hipsui].[IndigenousStatus](
	[IndigenousStatusId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](50) NOT NULL,
	[Description] [varchar](100) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_IndigenousStatus] PRIMARY KEY CLUSTERED 
(
	[IndigenousStatusId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[hipsui].[IndigenousStatus]') AND name = N'UK_IndigenousStatus_Code')
CREATE NONCLUSTERED INDEX [UK_IndigenousStatus_Code] ON [hipsui].[IndigenousStatus] 
(
	[Code] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[hipsui].[DF_IndigenousStatus_Order]') AND parent_object_id = OBJECT_ID(N'[hipsui].[IndigenousStatus]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_IndigenousStatus_Order]') AND type = 'D')
BEGIN
ALTER TABLE [hipsui].[IndigenousStatus] ADD  CONSTRAINT [DF_IndigenousStatus_Order]  DEFAULT ((0)) FOR [DisplayOrder]
END
End
GO

/****** Object:  Table [hipsui].[IvcDeliveryMethod]    ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hipsui].[IvcDeliveryMethod]') AND type in (N'U'))
BEGIN
CREATE TABLE [hipsui].[IvcDeliveryMethod](
	[IvcDeliveryMethodId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](20) NOT NULL,
	[Description] [varchar](100) NOT NULL,
	[RequiresDestination] [bit] NOT NULL,
	[RequiresDestinationConfirm] [bit] NOT NULL,
	[DestinationLabel] [varchar](50) NULL,
	[ValidationRegex] [varchar](256) NULL,
	[IsEnabled] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
 CONSTRAINT [PK_IvcDeliveryMethod] PRIMARY KEY CLUSTERED 
(
	[IvcDeliveryMethodId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[hipsui].[IvcDeliveryMethod]') AND name = N'UK_IvcDeliveryMethod_Code')
CREATE NONCLUSTERED INDEX [UK_IvcDeliveryMethod_Code] ON [hipsui].[IvcDeliveryMethod] 
(
	[Code] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[hipsui].[DF_IvcDeliveryMethod_Order]') AND parent_object_id = OBJECT_ID(N'[hipsui].[IvcDeliveryMethod]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_IvcDeliveryMethod_Order]') AND type = 'D')
BEGIN
ALTER TABLE [hipsui].[IvcDeliveryMethod] ADD  CONSTRAINT [DF_IvcDeliveryMethod_Order]  DEFAULT ((0)) FOR [DisplayOrder]
END
End
GO

/****** Object:  Table [hipsui].[MedicareConsent]   ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hipsui].[MedicareConsent]') AND type in (N'U'))
BEGIN
CREATE TABLE [hipsui].[MedicareConsent](
	[MedicareConsentId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](50) NOT NULL,
	[Description] [varchar](100) NOT NULL,
	[ParentMedicareConsentId] [int] NULL,
	[DisplayOrder] [int] NOT NULL,
	[IsEnabled] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_MedicareConsent] PRIMARY KEY CLUSTERED 
(
	[MedicareConsentId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hipsui].[FK_MedicareConsent_ParentMedicareConsent]') AND parent_object_id = OBJECT_ID(N'[hipsui].[MedicareConsent]'))
ALTER TABLE [hipsui].[MedicareConsent]  WITH CHECK ADD  CONSTRAINT [FK_MedicareConsent_ParentMedicareConsent] FOREIGN KEY([ParentMedicareConsentId])
REFERENCES [hipsui].[MedicareConsent] ([MedicareConsentId])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[hipsui].[FK_MedicareConsent_ParentMedicareConsent]') AND parent_object_id = OBJECT_ID(N'[hipsui].[MedicareConsent]'))
ALTER TABLE [hipsui].[MedicareConsent] CHECK CONSTRAINT [FK_MedicareConsent_ParentMedicareConsent]
GO
IF Not EXISTS (SELECT * FROM sys.default_constraints WHERE object_id = OBJECT_ID(N'[hipsui].[DF_MedicareConsent_DisplayOrder]') AND parent_object_id = OBJECT_ID(N'[hipsui].[MedicareConsent]'))
Begin
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_MedicareConsent_DisplayOrder]') AND type = 'D')
BEGIN
ALTER TABLE [hipsui].[MedicareConsent] ADD  CONSTRAINT [DF_MedicareConsent_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
END
End
GO

/****** Object:  Table [hipsui].[Setting]    ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hipsui].[Setting]') AND type in (N'U'))
BEGIN
CREATE TABLE [hipsui].[Setting](
	[SettingId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](50) NOT NULL,
	[Value] [varchar](50) NOT NULL,
	[SettingDescription] [nvarchar](200) NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Setting] PRIMARY KEY CLUSTERED 
(
	[SettingId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[hipsui].[Setting]') AND name = N'UK_Setting_Code')
CREATE NONCLUSTERED INDEX [UK_Setting_Code] ON [hipsui].[Setting]
(
	[Code] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

/****** Object:  Table [hipsui].[Sex]   ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hipsui].[Sex]') AND type in (N'U'))
BEGIN
CREATE TABLE [hipsui].[Sex](
	[SexId] [int] IDENTITY(1,1) NOT NULL,
	[Code] [varchar](50) NOT NULL,
	[Description] [varchar](100) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserCreated] [varchar](256) NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[UserModified] [varchar](256) NOT NULL,
 CONSTRAINT [PK_Sex] PRIMARY KEY CLUSTERED 
(
	[SexId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_PADDING OFF
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[hipsui].[Sex]') AND name = N'UK_Sex_Code')
CREATE NONCLUSTERED INDEX [UK_Sex_Code] ON [hipsui].[Sex] 
(
	[Code] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

